/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Node;

class VWJMSConfigurationDialog
extends VWModalDialog
implements ActionListener {
    public static final int STATUS_CANCEL = 0;
    public static final int STATUS_OK = 1;
    private int m_nStatus = 0;
    private VWXMLWrapper m_xmlWrapper = null;
    private JTextField m_queueConnectionFactoryTextField = null;
    private JTextField m_queueNameTextField = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWJMSConfigurationDialog(Frame parent, String componentDescriptor) throws Exception {
        super(parent);
        try {
            if (componentDescriptor != null && componentDescriptor.length() > 0) {
                this.m_xmlWrapper = new VWXMLWrapper(componentDescriptor);
            }
            this.initialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    public VWJMSConfigurationDialog(Dialog parent, String componentDescriptor) throws Exception {
        super(parent);
        try {
            if (componentDescriptor != null && componentDescriptor.length() > 0) {
                this.m_xmlWrapper = new VWXMLWrapper(componentDescriptor);
            }
            this.initialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    public String getComponentDescriptor() {
        try {
            if (this.m_xmlWrapper == null) {
                this.m_xmlWrapper = new VWXMLWrapper("fnpe_jms_component_descriptor", "http://www.filenet.com/process");
            }
            Node rootNode = this.m_xmlWrapper.getRootNode();
            this.m_xmlWrapper.setNodeValue(rootNode, "adaptor_name", VWResource.s_jmsAdaptorName);
            String description = VWXMLWrapper.getNodeValue(rootNode, "description");
            if (description == null || description.length() == 0) {
                this.m_xmlWrapper.setNodeValue(rootNode, "description", VWResource.s_jmsAdaptorDescription);
            }
            this.m_xmlWrapper.setNodeValue(rootNode, "adaptor_class", "filenet.vw.integrator.adaptors.jms.VWJMSAdaptor");
            this.m_xmlWrapper.setNodeValue(rootNode, "queue_connection_factory", this.m_queueConnectionFactoryTextField.getText());
            this.m_xmlWrapper.setNodeValue(rootNode, "queue", this.m_queueNameTextField.getText());
            return this.m_xmlWrapper.toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_okButton)) {
            if (!this.verifyData(this.m_queueConnectionFactoryTextField, VWResource.s_queueConnectionFactory)) {
                return;
            }
            if (!this.verifyData(this.m_queueNameTextField, VWResource.s_queueName)) {
                return;
            }
            this.m_nStatus = 1;
            this.setVisible(false);
        } else if (object.equals(this.m_cancelButton)) {
            this.m_nStatus = 0;
            this.setVisible(false);
        } else if (object.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc082.htm");
        }
    }

    private void initialize() {
        try {
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_jmsConfigDialogDim);
            if (dim == null) {
                dim = new Dimension(450, 150);
            }
            this.setSize(dim);
            this.setTitle(VWResource.s_jmsConfigDialogTitle);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
            if (this.m_xmlWrapper != null) {
                String value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "queue_connection_factory");
                if (value != null) {
                    this.m_queueConnectionFactoryTextField.setText(value);
                }
                if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "queue")) != null) {
                    this.m_queueNameTextField.setText(value);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_queueConnectionFactory)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_queueConnectionFactoryTextField = new JTextField();
            panel.add((Component)this.m_queueConnectionFactoryTextField, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_queueName)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_queueNameTextField = new JTextField();
            panel.add((Component)this.m_queueNameTextField, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            panel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
            this.getRootPane().setDefaultButton(this.m_okButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private boolean verifyData(JComponent control, String label) {
        String newValue = null;
        if (control instanceof JTextField) {
            newValue = ((JTextField)control).getText();
        }
        if (newValue != null && newValue.length() > 0) {
            return true;
        }
        Container parent = this.getParent();
        if (parent instanceof Frame) {
            JOptionPane.showMessageDialog((Frame)parent, VWResource.s_invalidPropertyValue.toString(label), VWResource.s_error, 0);
        } else if (parent instanceof Dialog) {
            JOptionPane.showMessageDialog((Dialog)parent, VWResource.s_invalidPropertyValue.toString(label), VWResource.s_error, 0);
        }
        return false;
    }
}

